//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

FocusScope {
    id : uiFilterStringInput

    property alias text : input.text

    signal inputAccepted()

    function clear() {
        input.text = "";
    }

    activeFocusOnTab : true

    onActiveFocusChanged : input.forceActiveFocus()

    implicitWidth  : input.implicitWidth + 12
    implicitHeight : 30

    Rectangle {
        id : background

        anchors.fill : parent
        color : UiColors.getColor(UiColors.White)
        border {
            width : 1
            color : UiColors.getColor(UiColors.ControlGrey20)
        }
        z : -1

        states : [
            State {
                name : "disabled"
                when : !uiFilterStringInput.enabled

                PropertyChanges {
                    target       : background
                    border.color : UiColors.getColor(
                                       UiColors.DisabledLightGrey13)
                }
            },
            State {
                name : "focus"
                when : uiFilterStringInput.activeFocus

                PropertyChanges {
                    target       : background
                    border.color : UiColors.getColor(UiColors.SelectionGreen)
                }
            }
        ]
    }

    TextInput {
        id : input

        x      : 6
        y      : 4
        width  : parent.width - 12
        font   : UiFonts.getFont(UiFonts.Light, 14)
        color  : UiColors.getColor(UiColors.Black)

        anchors.verticalCenter : parent.verticalCenter

        Keys.onTabPressed : event.accepted = true

        selectByMouse     : true
        selectionColor    : UiColors.getColor(UiColors.SelectionGreen)
        selectedTextColor : UiColors.getColor(UiColors.White)
        clip              : true
        onAccepted        : uiFilterStringInput.inputAccepted()
    }
}
